#pragma once
#include "afxwin.h"
#include "afxcmn.h"

// CDriverSettings1 dialog
class CDriverSettings1 : public CPropertyPage
{
#define MAX_BLACK_AREAS  10

	DECLARE_DYNAMIC(CDriverSettings1)

public:
	CDriverSettings1();
	virtual ~CDriverSettings1();
	virtual BOOL OnInitDialog();

// Dialog Data
	enum { IDD = IDD_DRIVERPAGE1 };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

	afx_msg void OnBnClickedBtnDriverboxclear();
	afx_msg void OnBnClickedBtnGUIcontrol();
	afx_msg void OnBnClickedBtnSharpness();
	afx_msg void OnBnClickedBtnColourcorrection();
	afx_msg void OnBnClickedBtnPowerlevel();
	afx_msg void OnBnClickedBtnResinarea();
	afx_msg void OnBnClickedGetActionRadio();
	afx_msg void OnBnClickedSetActionRadio();
	afx_msg void OnCbnSelchangeResinArea();
	afx_msg void OnEnChangeResinareaNo();

private:
	CMainSheet *Parent;
	BOOL Initialised;

	CEdit Driver1Msg;
	CButton Action;
	int DvrAction;
	CButton GUIUser;
	CButton GUIPrinter;
	CComboBox ColourCorrection;
	CEdit Sharpness;
	CSpinButtonCtrl Sharpness_Spin;
	CEdit YMCPower;
	CSpinButtonCtrl YMCPower_Spin;
	CEdit KPower;
	CSpinButtonCtrl KPower_Spin;
	CEdit OPower;
	CSpinButtonCtrl OPower_Spin;
	CComboBox ResinArea_Side;
	CEdit ResinArea_No;
	CSpinButtonCtrl ResinArea_No_Spin;
	CEdit ResinArea_Left;
	CSpinButtonCtrl ResinArea_Left_Spin;
	CEdit ResinArea_Width;
	CSpinButtonCtrl ResinArea_Width_Spin;
	CEdit ResinArea_Bottom;
	CSpinButtonCtrl ResinArea_Bottom_Spin;
	CEdit ResinArea_Height;
	CSpinButtonCtrl ResinArea_Height_Spin;
	CEdit WritePower;
	CSpinButtonCtrl WritePower_Spin;
	CButton EraseBeforePrint;

	void GUIControlToMsgBox(PID_GUICONTROL pControl,ID_READWRITE Action);
	void SetGUIControl(PID_GUICONTROL pControl);
	ID_RETURN GetGUIControl(PID_GUICONTROL pControl);

	void SharpnessToMsgBox(signed char Sharpness, ID_READWRITE Action);
	void SetSharpness(int Sharpness);
	ID_RETURN GetSharpness(signed char *pSharpness);

	void CorrectionToMsgBox(COLCORRECT Correction,	ID_READWRITE Action);
	void SetColourCorrection(COLCORRECT Correction);
	ID_RETURN GetColourCorrection(PCOLCORRECT pCorrection);

	void PowerLevelsToMsgBox(POWERLEVEL PowerLevel, ID_READWRITE Action);
	void SetPowerLevels(POWERLEVEL PowerLevel);
	ID_RETURN GetPowerLevels(PPOWERLEVEL pPowerLevel);

	void ResinAreaToMsgBox(ID_SIDE Side, int AreaNo, PAREA pArea, ID_READWRITE Action);
	void SetResinArea(PAREA pArea);
	ID_RETURN GetResinArea(ID_SIDE Side, int AreaNo, PAREA pArea);

	void EnableGetSetControls(BOOL bControl);

	BOOL ActionIsGet();
	void AddDriverMessage(CString pMessage);
};
